CREATE TABLE AB18A04T00
(
	T04_ID_ESQUEMA		  		NUMBER(5)  		NOT NULL ,
	T04_COD_ESQUEMA		  		VARCHAR2(50)  		NOT NULL ,
	T04_VERSION_ESQUEMA		  	VARCHAR2(50)  		NOT NULL ,
	T06_ID_BOLETIN	 			NUMBER(5) 	 		NOT NULL ,
	T04_FECHA_BAJA	    		DATE		 		NULL,
	T04_ESQUEMA		    		CLOB		 		NULL
)
	TABLESPACE AB18A01E00   
	LOB (T04_ESQUEMA) STORE AS AB18A04SL00  ( 
	TABLESPACE AB18A01E00
	DISABLE STORAGE IN ROW
	NOCACHE LOGGING);


COMMENT ON TABLE AB18A04T00 IS 'ESQUEMAS XSD. Tabla para almacenar los esquemas XSD relacionados con cada boletín.';


COMMENT ON COLUMN AB18A04T00.T04_ID_ESQUEMA IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A04T00.T04_COD_ESQUEMA IS 'Código identificativo del esquema.';

COMMENT ON COLUMN AB18A04T00.T04_VERSION_ESQUEMA IS 'Versión del esquema.';

COMMENT ON COLUMN AB18A04T00.T06_ID_BOLETIN IS 'Identificador del boletín sobre el que aplica el esquema.';

COMMENT ON COLUMN AB18A04T00.T04_FECHA_BAJA IS 'Fecha de baja lógica del fichero XSD.';

COMMENT ON COLUMN AB18A04T00.T04_ESQUEMA IS 'Fichero físico con el esquema XSD.';

ALTER TABLE AB18A04T00
	ADD (CONSTRAINT  PK_AB18A04T00 PRIMARY KEY (T04_ID_ESQUEMA)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

